<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

class CFormError {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $timeout = 1000;
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $popup = 0;
	
	

	public static function newInstance() {
		return new self();
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __construct() {
		return $this;
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddField($field , $msg = "") {
		$this->fields[$field] = $field;

		if ($msg != "") {
			$this->errors[$field] = $msg;
		}		

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddFields($fields) {
		if (is_array($fields)) {
			foreach ($fields as $key => $val) {
				$this->AddField($key , $val);
			}			
		}		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function ClearErrors() {
		$this->fields = array();
		$this->errors = array();
		
		return $this;
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddMessage($data) {
		$this->errors[] = $data;

		return $this;

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetHtml($data) {
		$this->html = $data;

		return $this;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetErrors() {
		return $this->errors;
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetSuccess($success) {
		$this->success = $success;

		return $this;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetReset() {
		$this->isReset = true;

		return $this;

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetDebug() {
		$this->isDebug = true;

		return $this;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetScript($script) {
		$this->script = $script;

		return $this;

	}
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetRedirect($redirect , $wait = 1000) {
		$this->redirect = $redirect;
		$this->wait = $wait;

		return $this;

	}
	
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetJson($mime = true) {

		if ($mime ) {
			header("Content-Type: application/json; charset=utf-8");
		}

		$this->html = $this->BuildHtml();

		if (is_array($this->fields) && $this->errorStyle) {
			$this->html = "";
		} else {
			unset($this->errors);
		}		


		$data = array(
			"status"	=> $this->status,
			"script"	=> $this->script,
			"fields"	=> is_array($this->fields) ? $this->fields : null,
			"message"	=> $this->errors,
			"redirect"	=> $this->redirect,
			"wait"		=> $this->timeout,
			"html"		=> $this->html,
			"reset"		=> $this->isReset ? "true" : "",
			"popup"		=> $this->popup,
			"popupbtn"	=> $this->popupButton
		);

		if ($this->isDebug) {
			$data["debug"] = array(
				"get"	=> $_GET,
				"post"	=> $_POST
			);
		}
		

		return json_encode($data, JSON_HEX_QUOT | JSON_HEX_TAG | JSON_HEX_APOS);
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BuildHTML() {
		global $_MODULES;

		if (is_object($_MODULES["common"])) {
			$_MODULES["common"]->__init();
		}

		if ($this->hasErrors()) {
			$this->popup = 0;
/*
			if ($this->popup == "1") {
				return $_MODULES["common"]->Popup(
					implode("<br>" , $this->errors),
					$this->popupbtn,
					$this->popupbg
				);
			}
*/

			if (is_object($_MODULES["common"])) {
				return $_MODULES["common"]->ErrorMSG($this->errors);
			} else {

			}
		} else {


			switch ($this->popup) {
				//standard response
				default:
				case "0":
					if (is_object($_MODULES["common"])) {
						return $_MODULES["common"]->SuccessMSG($this->success);
					}
				break;

				//popup
				case "1":
					return $_MODULES["common"]->Popup(
						$this->success,
						$this->popupbtn,
						$this->popupbg
					);
				break;

				case "2":
					$this->setRedirect($this->successRedirect , 100);
					if (is_object($_MODULES["common"])) {
						return $_MODULES["common"]->SuccessMSG($this->success);
					}
				break;
			}
			

			if ($this->popup == "1") {
			} else {			
			}
		}

		return $this;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function HasErrors() {
		return is_array($this->fields) && count($this->fields);
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetErrorStyle($type) {
		$this->errorStyle = $type;

		return $this;
	}

	/**
	* description	0 = under form , 1 = popup , 2 = redirect
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetSuccessStyle($type) {
		
		$this->popup = $type;
		return $this;
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetSuccessRedirect($url) {
		$this->successRedirect = $url;

		return $this;
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetPopupBtn($btn) {
		$this->popupbtn = $btn;

		return $this;
	}

		
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SetPopupBg($bg) {
		$this->popupbg = $bg;

		return $this;
	}
	
}

?>